function out = DAS_SASB_DRF(rf, no_ele, channelSpacing, speedSound, f)

ns = size(rf,1);   % number of samples
nl = size(rf,2);   % number of lines
sampleSpacing = 1/f * speedSound * 1000;
%sampleSpacing = (1/40e6*speedSound)*1000; % spacing between samples in photoacoustic imaging

postBF = zeros(ns,nl); % final image

count = ones(ns,nl); % to nomalize intensity
RF = rf;

for r = 1:nl % final line
    for j = 1:ns
        st_focus = j/2;
        hlfapt = round(((j-st_focus)*(sampleSpacing*1)/channelSpacing*(2/2)));
        for i = r-hlfapt:r+hlfapt
            if i > 0 && i <= nl
                depth = (j-st_focus)*(sampleSpacing);
                width = (r-i) * channelSpacing;
                rad = sqrt((depth)^2 + width^2);
                delay = st_focus + (rad)/(sampleSpacing);
                if round(delay) < ns
                    postBF(j,i) = postBF(j,i) + RF((round(delay)),r);
                    count(j,i) = count(j,i)+1;
                end
            end
        end
    end
end

out = postBF./(count);
